/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.fish;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.util.EntityUtils;

public class EntityTriggerfish
extends ComplexMobAquatic
implements ISpecies,
INewSkins {
    public EntityTriggerfish(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22279_, 0.6).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 1.8, false, 2.0f));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new TriggerFishBlowGoal(this, 600));
        this.f_21345_.m_25352_(4, (Goal)new ComplexMobAquatic.SwimGoal(this, 6));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.f_19797_ % 1000 == 0 && this.wantsToBreed() && !this.isMale()) {
                this.breed();
            }
            if (this.f_19853_.m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
            this.setAngry(this.m_5448_() != null);
        }
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.f_19853_.m_45976_(EntityTriggerfish.class, this.m_142469_().m_82377_(12.0, 8.0, 12.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.m_146762_(this.m_146764_());
                ((EntityTriggerfish)list.get(0)).m_146762_(this.m_146764_());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityUtils.dropEggs(this, "egg_triggerfish", this.getOffspring());
        return null;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12004_;
    }

    public class TriggerFishBlowGoal
    extends Goal {
        private final ComplexMobAquatic taskOwner;
        private final int chance;
        private BlockPos targetPos;
        private boolean taskComplete;
        private int counter;

        public TriggerFishBlowGoal(ComplexMobAquatic entityIn, int chance) {
            this.taskOwner = entityIn;
            this.chance = chance;
        }

        public boolean m_8036_() {
            if (this.taskOwner.m_21187_().nextInt(this.chance) == 0) {
                this.taskComplete = false;
                this.targetPos = this.getNearbySandBlock(this.taskOwner.m_142538_());
                return this.targetPos != null;
            }
            return false;
        }

        private BlockPos getNearbySandBlock(BlockPos roomCenter) {
            int X = 4;
            int Y = 6;
            for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)roomCenter.m_142082_(-X, -Y, -X), (BlockPos)roomCenter.m_142082_(X, 0, X))) {
                if (this.taskOwner.f_19853_.m_8055_(blockpos).m_60734_() != Blocks.f_49992_ || !this.taskOwner.f_19853_.m_8055_(blockpos.m_7494_()).m_60795_() || EntityTriggerfish.this.f_19796_.nextInt(2) != 0) continue;
                return blockpos;
            }
            return null;
        }

        public boolean m_8045_() {
            return !this.taskComplete && !this.taskOwner.m_21573_().m_26571_() && this.counter >= 0;
        }

        public void m_8056_() {
            this.taskOwner.m_21573_().m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_6630_(3).m_123342_(), (double)this.targetPos.m_123343_() + 0.5, 1.0);
        }

        public void m_8037_() {
            if (this.counter == 0 && this.taskOwner.m_20275_((double)this.targetPos.m_123341_() + 0.5, this.targetPos.m_7494_().m_123342_(), (double)this.targetPos.m_123343_() + 0.5) < 1.0) {
                this.counter = this.taskOwner.m_21187_().nextInt(20) + 30;
            }
            if (this.counter > 0) {
                --this.counter;
                if (this.counter == 0) {
                    Direction direction = this.taskOwner.m_6374_();
                    this.taskOwner.m_20256_(this.taskOwner.m_20184_().m_82520_((double)direction.m_122429_() * -0.2, 0.2, (double)direction.m_122431_() * -0.2));
                    this.taskOwner.m_21573_().m_26573_();
                    Level worldIn = this.taskOwner.m_183503_();
                    ((ServerLevel)worldIn).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, worldIn.m_8055_(this.targetPos)), (double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_7494_().m_123342_(), (double)this.targetPos.m_123343_() + 0.5, 50, 0.0, 0.0, 0.0, (double)0.15f);
                    this.taskComplete = true;
                }
            }
        }
    }
}

